DECLARE SUB LoadMap (file AS STRING)
DECLARE SUB DrawStatus ()
DECLARE SUB FillBoard ()
DECLARE SUB DrawScreen ()
DECLARE SUB GetVect (s%, o%, i%)
DECLARE SUB SetVect (s%, o%, i%)
DECLARE SUB InstallISR ()
DEFINT A-Z

'SHELL "cd\"
'SHELL "cd\games\qbasic\game"

'DIM SHARED path AS STRING: path = "A:\qbasic\hurkle\"
DIM SHARED path  AS STRING: path = "C:\GAMES\QBASIC\GAMES\HURKLE\"

' Key board stuff ===========================================================
DIM SHARED oldKeyIntSeg, oldKeyIntOff
DIM SHARED Keyboard(63)                 ' Keyboard flags for all the keys
'ON ERROR GOTO ErrorHandle
InstallISR                              ' Changes key board
DEF SEG = VARSEG(Keyboard(0))           ' Initialize
FOR i = 0 TO 127: POKE i, 128: NEXT i   ' the flags.
' ===========================================================================
CONST Released% = 1
CONST Pressed% = 0
CONST WALKSPEED! = .3
CONST WALKACC! = .1
CONST JUMPACC! = .5


TYPE ObjectType
        typ AS INTEGER
        Health AS INTEGER
        x AS SINGLE
        y AS SINGLE
        xV AS SINGLE
        yV AS SINGLE
        player AS STRING * 1
END TYPE


TYPE BoardType
        code AS STRING * 1
        fore AS STRING * 1
        back AS STRING * 1
        typ AS STRING * 1
END TYPE

DIM SHARED Map(1 TO 20, 1 TO 80) AS BoardType
DIM SHARED Obj AS ObjectType
DIM SHARED Shot AS ObjectType

DIM t AS LONG

DIM SHARED Gravity AS SINGLE

CLS
LoadMap "CAVE"
DrawStatus
DrawScreen

Gravity = .04

Obj.x = 5
Obj.y = 5
Shot.x = -1

DO
        ' Key testing =======================================================
        DEF SEG = VARSEG(Keyboard(0))
        KeyUp = PEEK(72)
        KeyDown = PEEK(80)
        KeyLeft = PEEK(75)
        KeyRight = PEEK(77)
        KeyShootL = PEEK(44)
        KeyShootR = PEEK(45)
        KeyEsc = PEEK(1)
        ' ===================================================================
        
        COLOR ASC(Map(Obj.y, Obj.x).fore), ASC(Map(Obj.y, Obj.x).back)
        LOCATE Obj.y, Obj.x: PRINT Map(Obj.y, Obj.x).code;
       

                IF KeyLeft = Pressed THEN
                        IF Obj.xV > -WALKSPEED THEN Obj.xV = Obj.xV - .1
                ELSEIF KeyRight = Pressed THEN
                        IF Obj.xV < WALKSPEED THEN Obj.xV = Obj.xV + .1
                ELSE
                        IF Obj.xV > 0 THEN
                                Obj.xV = Obj.xV - WALKACC
                                IF Obj.xV < 0 THEN Obj.xV = 0
                        ELSEIF Obj.xV < 0 THEN
                                Obj.xV = Obj.xV + WALKACC
                                IF Obj.xV > 0 THEN Obj.xV = 0
                        END IF
                END IF
        IF Map(Obj.y + 1, Obj.x).typ = CHR$(1) THEN
                IF KeyUp = Pressed THEN Obj.yV = -JUMPACC
        END IF
       
        IF KeyShootL = Pressed THEN
                Shot.x = Obj.x - 1
                Shot.y = Obj.y
                Shot.xV = -.5
        ELSEIF KeyShootR = Pressed THEN
                Shot.x = Obj.x + 1
                Shot.y = Obj.y
                Shot.xV = .5
        END IF


        ' ==================================================================
        Obj.yV = Obj.yV + Gravity
        IF Obj.yV > 1 THEN Obj.yV = 1

        IF ASC(Map(Obj.y, Obj.x + 1).typ) > 0 AND Obj.xV > 0 THEN Obj.xV = 0
        IF ASC(Map(Obj.y, Obj.x - 1).typ) > 0 AND Obj.xV < 0 THEN Obj.xV = 0
        Obj.x = Obj.x + Obj.xV
       
        IF ASC(Map(Obj.y + 1, Obj.x).typ) > 0 AND Obj.yV > 0 THEN Obj.yV = 0
        IF ASC(Map(Obj.y - 1, Obj.x).typ) > 0 AND Obj.yV < 0 THEN Obj.yV = 0
        Obj.y = Obj.y + Obj.yV
       
       
        Shot.x = Shot.x + Shot.xV
        IF Shot.x < 1 OR Shot.x > 80 THEN Shot.x = -1
        IF Shot.y < 1 OR Shot.y > 20 THEN Shot.x = -1
        ' ==================================================================
       
        COLOR 4, ASC(Map(Obj.y, Obj.x).back)
        LOCATE Obj.y, Obj.x: PRINT CHR$(2);
       
        IF Shot.x <> -1 THEN
                COLOR 14, ASC(Map(Shot.y, Shot.x).back)
                LOCATE Shot.y, Shot.x: PRINT CHR$(177);
        END IF

        FOR t = 0 TO 50000: NEXT t

LOOP UNTIL KeyEsc = Pressed

' Resets keyboard ===========================================================
'ErrorHandle:
SetVect oldKeyIntSeg, oldKeyIntOff, 9
DEF SEG = &H40
POKE &H17, PEEK(&H17) AND &HFAF0
' ===========================================================================

SUB DrawScreen
FOR y = 1 TO 20
        FOR x = 1 TO 80
                COLOR ASC(Map(y, x).fore), ASC(Map(y, x).back)
                LOCATE y, x: PRINT Map(y, x).code;
        NEXT x
NEXT y
END SUB

SUB DrawStatus
OPEN path + "STATUS.DAT" FOR INPUT AS #1

INPUT #1, r, c
FOR y = 21 TO 25
        FOR x = 1 TO 80
                INPUT #1, n1, n2, n3, n4
                COLOR n2, n3: LOCATE y, x: PRINT CHR$(n1);
        NEXT x
NEXT y

CLOSE #1
END SUB

' Written by Steven Sensarn.  Gets the address of the current ISR.
SUB GetVect (s, o, i)

    'GETVECT RETURNS THE ADDRESS OF A FUNCTION POINTED TO IN THE
    'INTERRUPT VECTOR TABLE (STARTS AT 0000:0000H)

    STATIC ASM AS STRING 'THE CODE FOR GETVECT

    STATIC INI AS INTEGER 'USED TO DETECT WHETHER GETVECT HAS PREVIOUSLY
                          'BEEN CALLED
    IF INI = 0 THEN
       
        'CREATE ML FUNCTION IF NOT ALREADY CREATED

        ASM = ASM + CHR$(&H55)                          'PUSH    BP
        ASM = ASM + CHR$(&H89) + CHR$(&HE5)             'MOV     BP,SP
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6) 'MOV     BX,[BP+06]
        ASM = ASM + CHR$(&H8A) + CHR$(&H7)              'MOV     AL,[BX]
        ASM = ASM + CHR$(&HB4) + CHR$(&H35)             'MOV     AH,35
        ASM = ASM + CHR$(&HCD) + CHR$(&H21)             'INT     21
        ASM = ASM + CHR$(&H53)                          'PUSH    BX
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA) 'MOV     BX,[BP+0A]
        ASM = ASM + CHR$(&H8C) + CHR$(&H7)              'MOV     [BX],ES
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8) 'MOV     BX,[BP+08]
        ASM = ASM + CHR$(&H58)                          'POP     AX
        ASM = ASM + CHR$(&H89) + CHR$(&H7)              'MOV     [BX],AX
        ASM = ASM + CHR$(&H5D)                          'POP     BP
        ASM = ASM + CHR$(&HCA) + CHR$(&H6) + CHR$(&H0)  'RETF    0006
        INI = 1 'FLAG CREATION
    END IF

    DEF SEG = VARSEG(ASM)
    CALL ABSOLUTE(s, o, i, SADD(ASM)) 'RUN FUNCTION

END SUB

' Installs the new ISR.  Based on a routine by Steven Sensarn, the asm code
' is entirely written by me, the rest is from a routine in KEYISR.BAS.
SUB InstallISR

DIM SGL AS INTEGER, SGH AS INTEGER          'Segment of keyboard()
DIM OFL AS INTEGER, OFH AS INTEGER          'Offset of keyboard()

DIM BYTE AS STRING * 1                      'USED TO ACTIVATE IRQ 1 IN PIC

STATIC ASM AS STRING                        'HOLDS ISR

SGL = VARSEG(Keyboard(0)) AND &HFF          'LOAD LOW "BYTE" SEGMENT
SGH = INT(VARSEG(Keyboard(0)) / 256) AND &HFF 'LOAD HIGH "BYTE" SEGMENT

OFL = VARPTR(Keyboard(0)) AND &HFF          'LOAD LOW "BYTE" OFFSET
OFH = INT(VARPTR(Keyboard(0)) / 256) AND &HFF 'LOAD HIGH "BYTE" OFFSET

'Assembly code for the ISR.

ASM = ""
ASM = ASM + CHR$(&H52)                          'PUSH DX       Save the
ASM = ASM + CHR$(&H51)                          'PUSH CX       registers we
ASM = ASM + CHR$(&H53)                          'PUSH BX       need to use.
ASM = ASM + CHR$(&H50)                          'PUSH AX
ASM = ASM + CHR$(&H1E)                          'PUSH DS
ASM = ASM + CHR$(&H56)                          'PUSH SI
ASM = ASM + CHR$(&HFB)                          'STI
ASM = ASM + CHR$(&HE4) + CHR$(&H60)             'IN   AL,60h   Get the key.
ASM = ASM + CHR$(&H30) + CHR$(&HE4)             'XOR  AH,AH
ASM = ASM + CHR$(&HB1) + CHR$(&H7F)             'MOV  CL,7Fh   [Key] AND 7Fh,
ASM = ASM + CHR$(&H88) + CHR$(&HC3)             'MOV  BL,AL    clears the
ASM = ASM + CHR$(&H20) + CHR$(&HCB)             'AND  BL,CL    high bit.
ASM = ASM + CHR$(&HBA) + CHR$(SGL) + CHR$(SGH)  'MOV  DX,SEG keyboard()
ASM = ASM + CHR$(&H8E) + CHR$(&HDA)             'MOV  DS,DX
ASM = ASM + CHR$(&HB1) + CHR$(&H80)             'MOV  CL,80h   [Key] AND 80h,
ASM = ASM + CHR$(&H20) + CHR$(&HC8)             'AND  AL,CL    gets high bit
ASM = ASM + CHR$(&H30) + CHR$(&HFF)             'XOR  BH,BH    true or false.
ASM = ASM + CHR$(&HBE) + CHR$(OFL) + CHR$(OFH)  'MOV  SI,OFFSET keyboard()
ASM = ASM + CHR$(&H1) + CHR$(&HDE)              'ADD  SI,BX    Put in true or
ASM = ASM + CHR$(&H88) + CHR$(&H4)              'MOV  [SI],AL  false for key.
ASM = ASM + CHR$(&HE4) + CHR$(&H61)             'IN   AL,61h
ASM = ASM + CHR$(&H80) + CHR$(&HCC) + CHR$(&H82)'OR   AH,82h   Let the port
ASM = ASM + CHR$(&HE6) + CHR$(&H61)             'OUT  61h,AL   know the key
ASM = ASM + CHR$(&H24) + CHR$(&H7F)             'AND  AL,7Fh   was read.
ASM = ASM + CHR$(&HE6) + CHR$(&H61)             'OUT  61h,AL
ASM = ASM + CHR$(&HB0) + CHR$(&H20)             'MOV  AL,20h   End the
ASM = ASM + CHR$(&HE6) + CHR$(&H20)             'OUT  20h,AL   interrupt.
ASM = ASM + CHR$(&H5E)                          'POP  SI
ASM = ASM + CHR$(&H1F)                          'POP  DS       Restore the
ASM = ASM + CHR$(&H58)                          'POP  AX       registers.
ASM = ASM + CHR$(&H5B)                          'POP  BX
ASM = ASM + CHR$(&H59)                          'POP  CX
ASM = ASM + CHR$(&H5A)                          'POP  DX
ASM = ASM + CHR$(&HCF)                          'IRET
        
BYTE = CHR$(INP(&H21)) 'LOAD IRQ ENABLE REGISTER IN PIC

OUT &H21, (ASC(BYTE) AND (255 XOR 2)) 'CLEAR BIT 2 (IRQ 1)

CALL GetVect(oldKeyIntSeg, oldKeyIntOff, &H9) 'LOAD OLD ISR
CALL SetVect(VARSEG(ASM), SADD(ASM), &H9) 'STORE NEW ISR

END SUB

SUB LoadMap (file AS STRING)
OPEN path + file + ".DAT" FOR INPUT AS #1

INPUT #1, r, c
FOR y = 1 TO r
        FOR x = 1 TO c
                INPUT #1, n1, n2, n3, n4
                Map(y, x).code = CHR$(n1)
                Map(y, x).fore = CHR$(n2)
                Map(y, x).back = CHR$(n3)
                Map(y, x).typ = CHR$(n4)
        NEXT x
NEXT y

CLOSE #1
END SUB

' Written by Steven Sensarn.  Sets a new ISR.
SUB SetVect (s, o, i)

    'SETVECT CHANGES THE ADDRESSES IN THE INTERRUPT VECTOR TABLE
    'TO POINT TO NEW FUNCTIONS

    STATIC ASM AS STRING 'HOLDS THE SETVECT FUNCTION
    STATIC INI AS INTEGER 'USED TO TEST WHETHER OR NOT FUNCTION HAS PREVOUSLY
                          'BEEN CALLED
    IF INI = 0 THEN

        'CREATE FUNCTION IF NOT ALREADY CREATED

        ASM = ""
        ASM = ASM + CHR$(&H55)                          'PUSH BP
        ASM = ASM + CHR$(&H89) + CHR$(&HE5)             'MOV BP,SP
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8) 'MOV BX,[BP+08]
        ASM = ASM + CHR$(&H8B) + CHR$(&H17)             'MOV DX,[BX]
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6) 'MOV BX,[BP+06]
        ASM = ASM + CHR$(&H8A) + CHR$(&H7)              'MOV AL,[BX]
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA) 'MOV BX,[BP+0A]
        ASM = ASM + CHR$(&H1E)                          'PUSH DS
        ASM = ASM + CHR$(&H8E) + CHR$(&H1F)             'MOV DS,[BX]
        ASM = ASM + CHR$(&HB4) + CHR$(&H25)             'MOV AH,25
        ASM = ASM + CHR$(&HCD) + CHR$(&H21)             'INT 21
        ASM = ASM + CHR$(&H1F)                          'POP DS
        ASM = ASM + CHR$(&H5D)                          'POP BP
        ASM = ASM + CHR$(&HCA) + CHR$(&H6) + CHR$(&H0)  'RETF 0006
        INI = 1 'FLAG CREATION
    END IF
    DEF SEG = VARSEG(ASM)
    CALL ABSOLUTE(s, o, i, SADD(ASM)) 'RUN SETVECT

END SUB

