DECLARE SUB GetVect (s%, o%, i%)
DECLARE SUB SetVect (s%, o%, i%)
DECLARE SUB InstallISR ()
DEFINT A-Z


' Key board stuff ===========================================================
DIM SHARED oldKeyIntSeg, oldKeyIntOff
DIM SHARED Keyboard(63)                 ' Keyboard flags for all the keys
'ON ERROR GOTO ErrorHandle
InstallISR                              ' Changes key board
DEF SEG = VARSEG(Keyboard(0))           ' Initialize
FOR i = 0 TO 127: POKE i, 128: NEXT i   ' the flags.
' ===========================================================================

CLS
DO
        
        DEF SEG = VARSEG(Keyboard(0))
        KeyEsc = PEEK(1)
        
        FOR i = 0 TO 128
                KeyPress = PEEK(i)
                IF KeyPress = 0 THEN
                        PRINT i
                END IF
        NEXT i

LOOP UNTIL KeyEsc = 0

' Resets keyboard ===========================================================
'ErrorHandle:
SetVect oldKeyIntSeg, oldKeyIntOff, 9
DEF SEG = &H40
POKE &H17, PEEK(&H17) AND &HFAF0
' ===========================================================================

' Written by Steven Sensarn.  Gets the address of the current ISR.
SUB GetVect (s, o, i)

    'GETVECT RETURNS THE ADDRESS OF A FUNCTION POINTED TO IN THE
    'INTERRUPT VECTOR TABLE (STARTS AT 0000:0000H)

    STATIC ASM AS STRING 'THE CODE FOR GETVECT

    STATIC INI AS INTEGER 'USED TO DETECT WHETHER GETVECT HAS PREVIOUSLY
                          'BEEN CALLED
    IF INI = 0 THEN
       
        'CREATE ML FUNCTION IF NOT ALREADY CREATED

        ASM = ASM + CHR$(&H55)                          'PUSH    BP
        ASM = ASM + CHR$(&H89) + CHR$(&HE5)             'MOV     BP,SP
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6) 'MOV     BX,[BP+06]
        ASM = ASM + CHR$(&H8A) + CHR$(&H7)              'MOV     AL,[BX]
        ASM = ASM + CHR$(&HB4) + CHR$(&H35)             'MOV     AH,35
        ASM = ASM + CHR$(&HCD) + CHR$(&H21)             'INT     21
        ASM = ASM + CHR$(&H53)                          'PUSH    BX
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA) 'MOV     BX,[BP+0A]
        ASM = ASM + CHR$(&H8C) + CHR$(&H7)              'MOV     [BX],ES
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8) 'MOV     BX,[BP+08]
        ASM = ASM + CHR$(&H58)                          'POP     AX
        ASM = ASM + CHR$(&H89) + CHR$(&H7)              'MOV     [BX],AX
        ASM = ASM + CHR$(&H5D)                          'POP     BP
        ASM = ASM + CHR$(&HCA) + CHR$(&H6) + CHR$(&H0)  'RETF    0006
        INI = 1 'FLAG CREATION
    END IF

    DEF SEG = VARSEG(ASM)
    CALL ABSOLUTE(s, o, i, SADD(ASM)) 'RUN FUNCTION

END SUB

' Installs the new ISR.  Based on a routine by Steven Sensarn, the asm code
' is entirely written by me, the rest is from a routine in KEYISR.BAS.
SUB InstallISR

DIM SGL AS INTEGER, SGH AS INTEGER          'Segment of keyboard()
DIM OFL AS INTEGER, OFH AS INTEGER          'Offset of keyboard()

DIM BYTE AS STRING * 1                      'USED TO ACTIVATE IRQ 1 IN PIC

STATIC ASM AS STRING                        'HOLDS ISR

SGL = VARSEG(Keyboard(0)) AND &HFF          'LOAD LOW "BYTE" SEGMENT
SGH = INT(VARSEG(Keyboard(0)) / 256) AND &HFF 'LOAD HIGH "BYTE" SEGMENT

OFL = VARPTR(Keyboard(0)) AND &HFF          'LOAD LOW "BYTE" OFFSET
OFH = INT(VARPTR(Keyboard(0)) / 256) AND &HFF 'LOAD HIGH "BYTE" OFFSET

'Assembly code for the ISR.

ASM = ""
ASM = ASM + CHR$(&H52)                          'PUSH DX       Save the
ASM = ASM + CHR$(&H51)                          'PUSH CX       registers we
ASM = ASM + CHR$(&H53)                          'PUSH BX       need to use.
ASM = ASM + CHR$(&H50)                          'PUSH AX
ASM = ASM + CHR$(&H1E)                          'PUSH DS
ASM = ASM + CHR$(&H56)                          'PUSH SI
ASM = ASM + CHR$(&HFB)                          'STI
ASM = ASM + CHR$(&HE4) + CHR$(&H60)             'IN   AL,60h   Get the key.
ASM = ASM + CHR$(&H30) + CHR$(&HE4)             'XOR  AH,AH
ASM = ASM + CHR$(&HB1) + CHR$(&H7F)             'MOV  CL,7Fh   [Key] AND 7Fh,
ASM = ASM + CHR$(&H88) + CHR$(&HC3)             'MOV  BL,AL    clears the
ASM = ASM + CHR$(&H20) + CHR$(&HCB)             'AND  BL,CL    high bit.
ASM = ASM + CHR$(&HBA) + CHR$(SGL) + CHR$(SGH)  'MOV  DX,SEG keyboard()
ASM = ASM + CHR$(&H8E) + CHR$(&HDA)             'MOV  DS,DX
ASM = ASM + CHR$(&HB1) + CHR$(&H80)             'MOV  CL,80h   [Key] AND 80h,
ASM = ASM + CHR$(&H20) + CHR$(&HC8)             'AND  AL,CL    gets high bit
ASM = ASM + CHR$(&H30) + CHR$(&HFF)             'XOR  BH,BH    true or false.
ASM = ASM + CHR$(&HBE) + CHR$(OFL) + CHR$(OFH)  'MOV  SI,OFFSET keyboard()
ASM = ASM + CHR$(&H1) + CHR$(&HDE)              'ADD  SI,BX    Put in true or
ASM = ASM + CHR$(&H88) + CHR$(&H4)              'MOV  [SI],AL  false for key.
ASM = ASM + CHR$(&HE4) + CHR$(&H61)             'IN   AL,61h
ASM = ASM + CHR$(&H80) + CHR$(&HCC) + CHR$(&H82)'OR   AH,82h   Let the port
ASM = ASM + CHR$(&HE6) + CHR$(&H61)             'OUT  61h,AL   know the key
ASM = ASM + CHR$(&H24) + CHR$(&H7F)             'AND  AL,7Fh   was read.
ASM = ASM + CHR$(&HE6) + CHR$(&H61)             'OUT  61h,AL
ASM = ASM + CHR$(&HB0) + CHR$(&H20)             'MOV  AL,20h   End the
ASM = ASM + CHR$(&HE6) + CHR$(&H20)             'OUT  20h,AL   interrupt.
ASM = ASM + CHR$(&H5E)                          'POP  SI
ASM = ASM + CHR$(&H1F)                          'POP  DS       Restore the
ASM = ASM + CHR$(&H58)                          'POP  AX       registers.
ASM = ASM + CHR$(&H5B)                          'POP  BX
ASM = ASM + CHR$(&H59)                          'POP  CX
ASM = ASM + CHR$(&H5A)                          'POP  DX
ASM = ASM + CHR$(&HCF)                          'IRET
        
BYTE = CHR$(INP(&H21)) 'LOAD IRQ ENABLE REGISTER IN PIC

OUT &H21, (ASC(BYTE) AND (255 XOR 2)) 'CLEAR BIT 2 (IRQ 1)

CALL GetVect(oldKeyIntSeg, oldKeyIntOff, &H9) 'LOAD OLD ISR
CALL SetVect(VARSEG(ASM), SADD(ASM), &H9) 'STORE NEW ISR

END SUB

' Written by Steven Sensarn.  Sets a new ISR.
SUB SetVect (s, o, i)

    'SETVECT CHANGES THE ADDRESSES IN THE INTERRUPT VECTOR TABLE
    'TO POINT TO NEW FUNCTIONS

    STATIC ASM AS STRING 'HOLDS THE SETVECT FUNCTION
    STATIC INI AS INTEGER 'USED TO TEST WHETHER OR NOT FUNCTION HAS PREVOUSLY
                          'BEEN CALLED
    IF INI = 0 THEN

        'CREATE FUNCTION IF NOT ALREADY CREATED

        ASM = ""
        ASM = ASM + CHR$(&H55)                          'PUSH BP
        ASM = ASM + CHR$(&H89) + CHR$(&HE5)             'MOV BP,SP
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8) 'MOV BX,[BP+08]
        ASM = ASM + CHR$(&H8B) + CHR$(&H17)             'MOV DX,[BX]
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6) 'MOV BX,[BP+06]
        ASM = ASM + CHR$(&H8A) + CHR$(&H7)              'MOV AL,[BX]
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA) 'MOV BX,[BP+0A]
        ASM = ASM + CHR$(&H1E)                          'PUSH DS
        ASM = ASM + CHR$(&H8E) + CHR$(&H1F)             'MOV DS,[BX]
        ASM = ASM + CHR$(&HB4) + CHR$(&H25)             'MOV AH,25
        ASM = ASM + CHR$(&HCD) + CHR$(&H21)             'INT 21
        ASM = ASM + CHR$(&H1F)                          'POP DS
        ASM = ASM + CHR$(&H5D)                          'POP BP
        ASM = ASM + CHR$(&HCA) + CHR$(&H6) + CHR$(&H0)  'RETF 0006
        INI = 1 'FLAG CREATION
    END IF
    DEF SEG = VARSEG(ASM)
    CALL ABSOLUTE(s, o, i, SADD(ASM)) 'RUN SETVECT

END SUB

