DECLARE SUB TestCrash ()
DECLARE SUB TestSpeed ()
DECLARE FUNCTION Rand% (Low%, High%)
DECLARE FUNCTION AbortGame% ()
DECLARE SUB ResetScore ()
DECLARE SUB WallWarp ()
DECLARE SUB Crash ()
DECLARE SUB MoveWorm ()
DECLARE FUNCTION TestKey% (k AS STRING)
DECLARE SUB ComputerBrain ()
DECLARE FUNCTION ComputerTest% (direct%, distance%)
DECLARE SUB SetStartSpots ()
DECLARE FUNCTION TestWinner% ()
DECLARE SUB SetPlayers ()
DECLARE SUB SetBoardType ()
DECLARE SUB SetKeys ()
DECLARE SUB SetBoardSize ()
DECLARE SUB GamePlay ()
DECLARE SUB EditOptions ()
DECLARE SUB SetColors ()
DECLARE SUB GetCirclePictures ()
DECLARE SUB DrawCircle (xx%, z%)
DECLARE SUB BigLetter (Word AS STRING, size%, Clr%, Style%, Position%)
DECLARE SUB LoadOptions ()
DECLARE SUB SaveOptions ()
DECLARE SUB Default ()
DECLARE SUB TypeStuff (yy%, xx%, dis AS STRING, nam AS STRING, num%)
DECLARE SUB SetVars ()
DECLARE SUB DrawBoard ()
DECLARE SUB DispMenu (num%, xx%, yy%, pick%)
DECLARE SUB TurnOnNumLock ()
DECLARE SUB Explode (DeadWorm%, size%)
DECLARE SUB PrintTotalWins ()
DECLARE SUB PrintRoundsWon ()
DECLARE SUB Pause ()
DEFINT A-Z       ' defines all variables as INTs
SCREEN 12        ' Sets screen to 640x480
RANDOMIZE TIMER  ' Randomizes timer
TurnOnNumLock    ' Turns on num lock
' constants
CONST PATH$ = "C:\GAMES"
CONST TRUE% = 1
CONST FALSE% = 0
CONST UP% = 0
CONST RIGHT% = 1
CONST DOWN% = 2
CONST LEFT% = 3
CONST DEAD% = 4  ' direction is set to 4 when a worm crashes
CONST WARP% = 0
CONST SOLID% = 1
CONST WORDSTYLE% = 12   ' big text style
CONST MENUSTART% = 10
CONST MENUEND% = 24

' Type statements
TYPE DataOptions                ' for the file
        ' Level settings
        DataWormSize AS INTEGER
        DataSpeed AS LONG
        DataWall AS INTEGER
        DataDensity AS INTEGER
        DataBoom AS INTEGER
        DataWins AS INTEGER
        DataRandStart AS INTEGER
        DataBoomStep AS INTEGER
        ' Computer players
        DataComp1 AS INTEGER
        DataComp2 AS INTEGER
        DataComp3 AS INTEGER
        DataComp4 AS INTEGER
        ' Player 1 keys
        DataUp1 AS STRING * 2
        DataDown1 AS STRING * 2
        DataLeft1 AS STRING * 2
        DataRight1 AS STRING * 2
        ' Player 2 keys
        DataUp2 AS STRING * 2
        DataDown2 AS STRING * 2
        DataLeft2 AS STRING * 2
        DataRight2 AS STRING * 2
        ' Player 3 keys
        DataUp3 AS STRING * 2
        DataDown3 AS STRING * 2
        DataLeft3 AS STRING * 2
        DataRight3 AS STRING * 2
        ' Player 4 keys
        DataUp4 AS STRING * 2
        DataDown4 AS STRING * 2
        DataLeft4 AS STRING * 2
        DataRight4 AS STRING * 2
        ' Total Wins
        DataTotal1 AS INTEGER
        DataTotal2 AS INTEGER
        DataTotal3 AS INTEGER
        DataTotal4 AS INTEGER
END TYPE

TYPE WormType
        x AS INTEGER     ' worm x position
        y AS INTEGER     ' worm y position
        d AS INTEGER     ' worm direction
        c AS INTEGER     ' worm type player/computer(& skill levels)/none
END TYPE

' Dimmentions record length
DIM SHARED Options AS DataOptions

' Gloabal vars
DIM SHARED CurrentWorm               ' Used in game play loop
DIM SHARED Xmin                      ' Min X cordinate
DIM SHARED Xmax                      ' Max X cordinate
DIM SHARED Ymin                      ' Min Y cordinate
DIM SHARED Ymax                      ' Max Y cordinate
DIM SHARED WormSize                  ' borad size
DIM SHARED Speed AS LONG             ' worm speed (loops per second)
DIM SHARED Wall                      ' solid or warp
DIM SHARED Density                   ' number of walls
DIM SHARED Boom                      ' explosion size
DIM SHARED BoomStep                  ' explosion density
DIM SHARED Wins                      ' number of wins needed to win battle
DIM SHARED RandStart                 ' if random start spots
DIM SHARED LoopSecond AS LONG
DIM SHARED Loser

' Gloabal arrays
DIM SHARED StorePic(1 TO 100, 1 TO 4) AS SINGLE  ' stores
DIM SHARED Worm(1 TO 4) AS WormType              ' worm location, direction
DIM SHARED Keys(1 TO 4, 1 TO 4) AS STRING        ' key configration
DIM SHARED NumWin(1 TO 4)                        ' number of rounds won
DIM SHARED TotalWin(1 TO 4)                      ' number of games won
DIM SHARED ColorName(1 TO 4) AS STRING           ' stores color name strings
DIM SHARED Colors(1 TO 4)                        ' stores color of each worm

SetColors ' Fills color arrays

TestSpeed ' tests speed of computer

' Loads saved options
OPEN PATH$ + "MANYWORM.DAT" FOR RANDOM AS #1 LEN = LEN(Options)

' If file is empty, all is set to default
IF LOF(1) / LEN(Options) <> 1 THEN
        Default
        SaveOptions
ELSE  ' File is loaded
        LoadOptions
END IF

' Start of main program loop
DO
        CLS
        PrintTotalWins
        COLOR 15: LOCATE 11, 30: PRINT "MANY WORM v1.1"
        DispMenu 1, 28, 12, pick
                SELECT CASE pick
                        CASE 1
                                GamePlay
                        CASE 2
                                EditOptions
                END SELECT
LOOP UNTIL pick = 3 OR Loser = 1
CLOSE #1
' End of program

' All data

' Data for all menus
menudata:
' Menu #1
DATA 3,"START GAME","SETTINGS","QUIT WORM"
' Menu #2
DATA 8,"CHANGE BOARD SIZE","PLAYER SETTINGS","CHANGE SETTINGS"
DATA "CUSTOMIZE CONTROLS","RESET TO DEFAULT","SAVE CURRENT OPTIONS"
DATA "RESET SCORES","BACK TO MAIN MENU"
' Menu #3
DATA 9,"MINUTE","TINY","EXTRA SMALL","SMALL","NORMAL"
DATA "LARGE","EXTRA LARGE","MASSIVE","BEYOND MASSIVE"
' Menu #4
DATA 2,"NO","YES"

' Data for setting colors & color names
playname:
DATA BLUE,9
DATA RED,4
DATA GREEN,2
DATA YELLOW,14

' Misc. data
onoff:
DATA "OFF       ","PLAYER    ","COMPUTER 0","COMPUTER 1","COMPUTER 2"
DATA "COMPUTER 3","COMPUTER 4","COMPUTER 5","COMPUTER 6","COMPUTER 7"
DATA "COMPUTER 8","COMPUTER 9"

walltype:
DATA "WARP ","SOLID"

yesno:
DATA "OFF","ON "

' Data for circles with even radi

size4data:
DATA 0,1,1,0
DATA 1,1,1,1
DATA 1,1,1,1
DATA 0,1,1,0

size6data:
DATA 0,1,1,1,1,0
DATA 1,1,1,1,1,1
DATA 1,1,1,1,1,1
DATA 1,1,1,1,1,1
DATA 1,1,1,1,1,1
DATA 0,1,1,1,1,0

size8data:
DATA 0,0,1,1,1,1,0,0
DATA 0,1,1,1,1,1,1,0
DATA 1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1
DATA 0,1,1,1,1,1,1,0
DATA 0,0,1,1,1,1,0,0

FUNCTION AbortGame%
DIM temp(1932) AS SINGLE
GET (264, 112)-STEP(88, 160), temp
COLOR 15: LOCATE 11, 34: PRINT "MASS  KILL?"
DispMenu 4, 34, 12, pick
PUT (264, 112), temp, PSET

' All worms are set to the dead state if yes
IF pick = 2 THEN
        FOR x = 1 TO 4
                IF Worm(x).d < DEAD THEN
                        Worm(x).d = DEAD
                        Explode x, 640
                END IF
        NEXT x
        AbortGame% = TRUE
END IF
END FUNCTION

' Style 1-16
SUB BigLetter (Word AS STRING, size, Clr, Style, Position)
COLOR 8
   DIM Box(-1 TO 7, -1 TO 15)
   Wordlength = LEN(Word$) * size * 8
   WordHeight = size * 16
   WordCenter = 320 - (Wordlength / 2) ' 320 screen 12, 160 screen 13
   PALETTE 8, 0
   FOR Letter = 1 TO LEN(Word$)
     LOCATE 30, 80
     PRINT MID$(Word$, Letter, 1);
     xx = 0
     yy = 0
     FOR x = 632 TO 639
       yy = 0
       FOR y = 464 TO 479
        Box(xx, yy) = POINT(x, y)
        yy = yy + 1
       NEXT y
       xx = xx + 1
     NEXT x
     FOR x = 0 TO 7
       Bleft = WordCenter + (x * size)
       Bright = Bleft + size
       lr = (Bleft + Bright) \ 2
       FOR y = 0 TO 15
         Bup = Position + (y * size)
         Bdown = Bup + size
         UD = (Bup + Bdown) \ 2
         IF Box(x, y) THEN
           SELECT CASE Style
              CASE 1
                'solid
                LINE (Bleft, Bup)-(Bright, Bdown), Clr, BF
              CASE 2
                'squares
                 LINE (Bleft, Bup)-(Bright, Bdown), Clr, B
              CASE 3
                'slant (\)
                 LINE (Bleft, Bup)-(Bright, Bdown), Clr
              CASE 4
                'slant (/)
                LINE (Bright, Bup)-(Bleft, Bdown), Clr
              CASE 5
                'Vertical Lines
                LINE (lr, Bup)-(lr, Bdown), Clr
              CASE 6
                'Horizontal Lines
                LINE (Bleft, UD)-(Bright, UD), Clr
              CASE 7
                'Crosses
                LINE (lr, Bup)-(lr, Bdown), Clr
                LINE (Bleft, UD)-(Bright, UD), Clr
              CASE 8
                'X's
                 LINE (Bleft, UP)-(Bright, Bdown), Clr
                 LINE (Bright, UP)-(Bleft, Bdown), Clr
              CASE 9
                'outline
                IF Box(x - 1, y) = 0 THEN LINE (Bleft, Bup)-(Bleft, Bdown), Clr
                IF Box(x + 1, y) = 0 THEN LINE (Bright, Bup)-(Bright, Bdown), Clr
                IF Box(x, y - 1) = 0 THEN LINE (Bleft, Bup)-(Bright, Bup), Clr
                IF Box(x, y + 1) = 0 THEN LINE (Bleft, Bdown)-(Bright, Bdown), Clr
              CASE 10
               'Spider Web
                IF Box(x - 1, y) = 0 THEN LINE (lr, UD)-(Bleft, UD), Clr
                IF Box(x + 1, y) = 0 THEN LINE (lr, UD)-(Bright, UD), Clr
                IF Box(x, y - 1) = 0 THEN LINE (lr, UD)-(lr, Bup), Clr
                IF Box(x, y + 1) = 0 THEN LINE (lr, UD)-(lr, Bdown), Clr
                IF Box(x - 1, y - 1) = 0 THEN LINE (lr, UD)-(Bleft, Bup), Clr
                IF Box(x + 1, y - 1) = 0 THEN LINE (lr, UD)-(Bright, Bup), Clr
                IF Box(x - 1, y + 1) = 0 THEN LINE (lr, UD)-(Bleft, Bdown), Clr
                IF Box(x + 1, y + 1) = 0 THEN LINE (lr, UD)-(Bright, Bdown), Clr
              CASE 11
                'Bubbles
                CIRCLE (lr, UD), size \ 2, Clr
              CASE 12
                'Circles
                CIRCLE (lr, UD), size \ 2, Clr
                PAINT STEP(0, 0), Clr
              CASE 13
                'Shadow
                IF Box(x + 1, y) = 0 THEN LINE (Bright, Bup)-(Bright, Bdown), Clr
                IF Box(x, y + 1) = 0 THEN LINE (Bleft, Bdown)-(Bright, Bdown), Clr
                IF Box(x + 1, y + 1) = 0 THEN PSET (RIGHT, DOWN), Clr
              CASE 14
                'Seperated squares
                LINE (Bleft + 1, Bup + 1)-(Bright - 1, Bdown - 1), Clr, BF
              CASE 15
                'building
                LINE (Bleft, Bdown)-(lr, Bup), Clr
                LINE STEP(0, 0)-(Bright, Bdown), Clr
                LINE STEP(0, 0)-(Bleft, Bdown), Clr
                LINE (Bleft, Bup)-(Bright, Bup), Clr
              CASE 16
                'STARS
                LINE (lr, Bup)-(lr, Bdown), Clr
                LINE (Bleft, UD)-(Bright, UD), Clr
                LINE (Bleft, Bup)-(Bright, Bdown), Clr
                LINE (Bright, Bup)-(Bleft, Bdown), Clr
              END SELECT
           END IF
         NEXT y
       NEXT x
     WordCenter = WordCenter + (size * 8)
   NEXT Letter
   LOCATE 30, 80
   PRINT " ";
   PALETTE
END SUB

SUB ComputerBrain
' Controls computer players

' Find worm's intelligence
comp = 12 - Worm(CurrentWorm).c
'comp = Worm(CurrentWorm).c - 1

' Finds directon to the right & left
TurnRight = Worm(CurrentWorm).d + 1
TurnLeft = Worm(CurrentWorm).d - 1

IF TurnRight = LEFT + 1 THEN TurnRight = UP ' loops back to up from left
IF TurnLeft = UP - 1 THEN TurnLeft = LEFT   ' loops back to left from up

' Tests spaces ahead of worm
' The lower the computer skill, the farther it tests ahead
DO
        x = x + 1
        test = ComputerTest(Worm(CurrentWorm).d, x)
LOOP UNTIL test = TRUE OR x = comp

' if anything is in the way
IF test = TRUE THEN
        testRight = ComputerTest(TurnRight, 1) ' test space to the right
        testLeft = ComputerTest(TurnLeft, 1)   ' test space to the left
        IF Rand(0, 1) = 0 THEN                 ' Randomly turns left or right
                ' try right first
                IF testRight = FALSE THEN      ' if it can, turn right
                        Worm(CurrentWorm).d = TurnRight
                ELSEIF testLeft = FALSE THEN   ' else, if it can, turn left
                        Worm(CurrentWorm).d = TurnLeft
                END IF
        ELSE
                ' try left first
                IF testLeft = FALSE THEN       ' if it can, turn left
                        Worm(CurrentWorm).d = TurnLeft
                ELSEIF testRight = FALSE THEN  ' else, if it can, turn right
                        Worm(CurrentWorm).d = TurnRight
                END IF
        END IF
END IF
END SUB

FUNCTION ComputerTest% (direct, distance)
' Tests spot in front of worm
SELECT CASE direct
        CASE UP
                yy = distance * -1
        CASE RIGHT
                xx = distance
        CASE DOWN
                yy = distance
        CASE ELSE
                xx = distance * -1
END SELECT

' Tests point
PointColor = POINT((Worm(CurrentWorm).x + xx) * WormSize + INT(WormSize / 2), (Worm(CurrentWorm).y + yy) * WormSize + INT(WormSize / 2))

IF PointColor > 0 THEN ' worms can only go through black
        test = TRUE
ELSE
        test = FALSE
END IF

' If wall warping is on
IF Wall = WARP THEN
        IF Worm(CurrentWorm).x + xx < Xmin OR Worm(CurrentWorm).x + xx > Xmax THEN
                test = FALSE
        END IF
        IF Worm(CurrentWorm).y + yy < Ymin OR Worm(CurrentWorm).y + yy > Ymax THEN
                test = FALSE
        END IF
END IF
ComputerTest% = test
END FUNCTION

SUB Crash
PLAY "mbmsl64n78n80n79"   ' makes silly sound
Explode CurrentWorm, Boom ' Draws explosion to set size
Worm(CurrentWorm).d = DEAD ' Makes worm state crashed
PrintRoundsWon            ' Reprints win bar
END SUB

SUB Default
' Sets all options to default
WormSize = 5 ' Sets worm size
Speed = 999 ' Sets Speed
Wall = SOLID ' Sets wall type
Density = 0 ' Sets density of walls
Boom = 0 ' Sets explosions
Wins = 3  ' Sets number of wins
RandStart = FALSE ' sets random start spots
BoomStep = 5
' Sets player types
Worm(1).c = 1
Worm(2).c = 1
Worm(3).c = 0
Worm(4).c = 0
' Sets keys for all players
' Player 1
Keys(1, 1) = "W"
Keys(1, 2) = "S"
Keys(1, 3) = "A"
Keys(1, 4) = "D"
' Player 2
Keys(2, 1) = "I"
Keys(2, 2) = "K"
Keys(2, 3) = "J"
Keys(2, 4) = "L"
' Player 3
Keys(3, 1) = CHR$(0) + "H"
Keys(3, 2) = CHR$(0) + "P"
Keys(3, 3) = CHR$(0) + "K"
Keys(3, 4) = CHR$(0) + "M"
' Player 4
Keys(4, 1) = "5"
Keys(4, 2) = "6"
Keys(4, 3) = "3"
Keys(4, 4) = "9"
END SUB

SUB DispMenu (num, xx, yy, pick)
DIM menu AS STRING
DIM k AS STRING
RESTORE menudata
FOR x = 1 TO num - 1
        READ words
        FOR y = 1 TO words
                READ menu
        NEXT y
NEXT x
READ words
DIM choice(1 TO words) AS STRING
FOR x = 1 TO words
        READ menu
        choice(x) = menu
NEXT x
FOR x = 1 TO words
        IF LEN(choice(x)) > lng THEN lng = LEN(choice(x))
NEXT x
lng = lng + 7
size = words + 3
COLOR 4
FOR x = xx + 1 TO lng + xx - 1
        LOCATE yy, x: PRINT "" ' 205
NEXT x
FOR x = xx + 1 TO lng + xx - 1
        LOCATE yy + size, x: PRINT ""' 205
NEXT x
FOR x = yy + 1 TO size + yy - 1
        LOCATE x, xx: PRINT ""'186
NEXT x
FOR x = yy + 1 TO size + yy% - 1
        LOCATE x, xx + lng: PRINT ""'186
NEXT x
LOCATE yy, xx: PRINT "" ' 201
LOCATE yy + size, xx: PRINT "" ' 200
LOCATE yy, xx + lng: PRINT "" ' 187
LOCATE yy + size, xx + lng: PRINT "" ' 188
COLOR 0
FOR y = yy + 1 TO size + yy - 1
        FOR x = xx + 1 TO lng + xx - 1
                LOCATE y, x: PRINT " "
        NEXT x
NEXT y
COLOR 7
FOR x = 1 TO words
        LOCATE x + yy + 1, xx + 4
        'LOCATE x + yy + 1, xx + INT(lng - 8 - LEN(choice(x)) / 2)
        PRINT choice(x);
NEXT x
ycr = yy + 2
xcr = xx + 2
COLOR 15
LOCATE ycr, xcr: PRINT CHR$(26)
LOCATE ycr, xcr + lng - 4: PRINT CHR$(27)
pick = 1
DO
        k = INKEY$
        IF k <> "" THEN
                LOCATE ycr, xcr: PRINT " "
                LOCATE ycr, xcr + lng - 4: PRINT " "
        END IF
        SELECT CASE k
                CASE CHR$(0) + "H"
                IF pick > 1 THEN
                        ycr = ycr - 1
                        pick = pick - 1
                ELSE
                        pick = words
                        ycr = yy + words + 1
                END IF
                CASE CHR$(0) + "P"
                IF pick < words THEN
                        ycr = ycr + 1
                        pick = pick + 1
                ELSE
                        ycr = yy + 2
                        pick = 1
                END IF
                CASE CHR$(13)
                EXIT DO
        END SELECT
        IF k <> "" THEN
                LOCATE ycr, xcr: PRINT CHR$(26)
                LOCATE ycr, xcr + lng - 4: PRINT CHR$(27)
        END IF
LOOP
END SUB

SUB DrawBoard
CLS
COLOR 15
LOCATE 30, 35: PRINT "Loading...";
' Draws borders of box
' Top border
FOR x = 0 TO Xmax
        LINE (x * WormSize, 0)-STEP(WormSize - 1, WormSize - 1), 7, BF
NEXT x
' Bottom border
FOR x = 0 TO Xmax
        LINE (x * WormSize, Ymax * WormSize)-STEP(WormSize - 1, WormSize - 1), 7, BF
NEXT x
' Left border
FOR x = 0 TO Ymax
        LINE (0, x * WormSize)-STEP(WormSize - 1, WormSize - 1), 7, BF
NEXT x
' Right border
FOR x = 0 TO Ymax
        LINE (Xmax * WormSize, x * WormSize)-STEP(WormSize - 1, WormSize - 1), 7, BF
NEXT x

SetStartSpots     ' sets start spots

' Draws in random walls
IF Density > 0 THEN
        FOR z = 1 TO Density
                x = INT(RND * Xmax - 2 + 1) + 2
                y = INT(RND * Ymax - 2 + 1) + 2
                LINE (x * WormSize, y * WormSize)-STEP(WormSize - 1, WormSize - 1), 7, BF
        NEXT z
END IF
LOCATE 30, 35: PRINT "          ";
PrintRoundsWon ' Prints wins
END SUB

SUB DrawCircle (xx, z)
' draws circles from data
FOR y = 1 TO xx
        FOR x = 1 TO xx
                READ pixel
                IF pixel > 0 THEN
                        PSET (x, y), Colors(z)
                END IF
        NEXT x
NEXT y
GET (1, 1)-(xx, xx), StorePic(1, z)
END SUB

SUB EditOptions
DO
        CLS
        PrintTotalWins
        COLOR 15: LOCATE 9, 31: PRINT "OPTIONS MENU"
        DispMenu 2, 24, 10, pick
        SELECT CASE pick
                CASE 1
                        SetBoardSize
                CASE 2
                        SetPlayers
                CASE 3
                        SetBoardType
                CASE 4
                        SetKeys
                CASE 5
                        Default
                CASE 6
                        SaveOptions
                CASE 7
                        ResetScore
        END SELECT
LOOP UNTIL pick = 8
END SUB

SUB Explode (DeadWorm, size)
' makes worm explode
FOR x = 1 TO size STEP BoomStep
        CIRCLE (Worm(DeadWorm).x * WormSize + INT(WormSize / 2), Worm(DeadWorm).y * WormSize + INT(WormSize / 2)), x, Colors(DeadWorm)
NEXT x
END SUB

SUB GamePlay
' Dimmentions key array
DIM k(10) AS STRING
DIM delay AS LONG
DIM i AS LONG
DIM Time AS DOUBLE
DIM StartTime AS DOUBLE
DIM seconds AS DOUBLE
' Gets pictures & sets board boundries
SetVars

delay = LoopSecond / Speed

seconds = .001

Time = TIMER
StartTime = Time

' Main play loop
DO
        DrawBoard    ' draws board
        DO
                ' Get key
                FOR x = 1 TO 10
                        k(x) = UCASE$(INKEY$)
                NEXT x
               
                ' Tests for the ESC button
                x = 1
                DO
                        IF k(x) = CHR$(27) THEN
                                abort = AbortGame
                                EXIT DO
                        END IF
                        x = x + 1
                LOOP UNTIL x = 10
               
                ' Test for which key was pressed or computer control
                FOR CurrentWorm = 1 TO 4
                        IF Worm(CurrentWorm).d <> DEAD THEN
                                IF Worm(CurrentWorm).c = 1 THEN
                                        x = 1
                                        hit = FALSE
                                        ' Allows only one action per loop
                                        ' for each player
                                        DO
                                                hit = TestKey(k(x))
                                                x = x + 1
                                        LOOP UNTIL x = 10 OR hit = TRUE
                                ELSE
                                        ComputerBrain
                                END IF
                        END IF
                NEXT CurrentWorm
               
                ' Moves the worms
                FOR CurrentWorm = 1 TO 4
                        IF Worm(CurrentWorm).d <> DEAD THEN
                                MoveWorm
                        END IF
                NEXT CurrentWorm
               
                ' Tests for all collisions
                FOR CurrentWorm = 1 TO 4
                        IF Worm(CurrentWorm).d <> DEAD THEN
                                TestCrash
                        END IF
                NEXT CurrentWorm
               
                ' Displays worms on screen
                FOR CurrentWorm = 1 TO 4
                        IF Worm(CurrentWorm).d <> DEAD THEN
                                PUT (Worm(CurrentWorm).x * WormSize, Worm(CurrentWorm).y * WormSize), StorePic(1, CurrentWorm), PSET
                        END IF
                NEXT CurrentWorm
               
                ' checks to see if anyone has won the game      
                death = 0
                FOR CurrentWorm = 1 TO 4
                        IF Worm(CurrentWorm).d = DEAD THEN death = death + 1
                NEXT CurrentWorm
                IF death >= 3 THEN done = TRUE

                DO
                        Time = TIMER
                LOOP UNTIL Time > StartTime + seconds
                Time = TIMER
                StartTime = Time

                ' speed control
                'FOR i = 0 TO delay: NEXT i
     
        LOOP WHILE done = FALSE
        done = FALSE
        ' Tests to see who won and if they won the game and
        ' if the game was aborted
        IF TestWinner > 0 OR abort = TRUE THEN done = TRUE
LOOP WHILE done = FALSE
END SUB

SUB GetCirclePictures
' Loads pictures into array
temp = INT(WormSize / 2)
FOR z = 1 TO 4
        CLS
        IF WormSize / 2 <> INT(WormSize / 2) THEN
                ' Gets circle for worm's body
                IF WormSize > 1 THEN
                        CIRCLE (temp + 1, temp + 1), temp, Colors(z)
                        PAINT (temp + 1, temp + 1), Colors(z)
                        GET (1, 1)-STEP(WormSize - 1, WormSize - 1), StorePic(1, z)
                ELSE    ' If the worm is only one pixel
                        PSET (0, 0), Colors(z)
                        GET (0, 0)-(0, 0), StorePic(1, z)
                END IF
        ELSE
                ' Draws custom even radius circles
                SELECT CASE WormSize
                        CASE 2
                                LINE (0, 0)-STEP(1, 1), Colors(z%), BF
                                GET (0, 0)-STEP(1, 1), StorePic(1, z%)
                        CASE 4
                                RESTORE size4data
                                DrawCircle 4, z
                        CASE 6
                                RESTORE size6data
                                DrawCircle 6, z
                        CASE 8
                                RESTORE size8data
                                DrawCircle 8, z
                END SELECT
        END IF
NEXT z
END SUB

SUB LoadOptions
' Loads all options
GET #1, 1, Options
WormSize = Options.DataWormSize
Speed = Options.DataSpeed
Wall = Options.DataWall
Density = Options.DataDensity
Boom = Options.DataBoom
Wins = Options.DataWins
RandStart = Options.DataRandStart
BoomStep = Options.DataBoomStep
' Type of players
Worm(1).c = Options.DataComp1
Worm(2).c = Options.DataComp2
Worm(3).c = Options.DataComp3
Worm(4).c = Options.DataComp4
' Player 1 keys
Keys(1, 1) = Options.DataUp1
Keys(1, 2) = Options.DataDown1
Keys(1, 3) = Options.DataLeft1
Keys(1, 4) = Options.DataRight1
' Player 2 keys
Keys(2, 1) = Options.DataUp2
Keys(2, 2) = Options.DataDown2
Keys(2, 3) = Options.DataLeft2
Keys(2, 4) = Options.DataRight2
' Player 3 keys
Keys(3, 1) = Options.DataUp3
Keys(3, 2) = Options.DataDown3
Keys(3, 3) = Options.DataLeft3
Keys(3, 4) = Options.DataRight3
' Player 4 keys
Keys(4, 1) = Options.DataUp4
Keys(4, 2) = Options.DataDown4
Keys(4, 3) = Options.DataLeft4
Keys(4, 4) = Options.DataRight4
' Takes spaces off the ends
FOR y% = 1 TO 4
        FOR x% = 1 TO 4
                IF RIGHT$(Keys(y%, x%), 1) = " " THEN
                        Keys(y%, x%) = LEFT$(Keys(y%, x%), 1)
                END IF
        NEXT x%
NEXT y%
' loads total wins
TotalWin(1) = Options.DataTotal1
TotalWin(2) = Options.DataTotal2
TotalWin(3) = Options.DataTotal3
TotalWin(4) = Options.DataTotal4
END SUB

SUB MoveWorm
SELECT CASE Worm(CurrentWorm).d
        CASE UP
                Worm(CurrentWorm).y = Worm(CurrentWorm).y - 1
        CASE RIGHT
                Worm(CurrentWorm).x = Worm(CurrentWorm).x + 1
        CASE DOWN
                Worm(CurrentWorm).y = Worm(CurrentWorm).y + 1
        CASE ELSE
                Worm(CurrentWorm).x = Worm(CurrentWorm).x - 1
END SELECT
END SUB

SUB Pause
DO: LOOP WHILE INKEY$ = ""
END SUB

SUB PrintRoundsWon
' Prints wins durring game
y = 3
FOR x = 1 TO 4
        COLOR Colors(x)
        LOCATE 30, y: PRINT "WINS:"; NumWin(x);
        IF Worm(x).d = DEAD THEN LOCATE 30, y - 2: PRINT CHR$(15);
        y = y + 23
NEXT x
END SUB

SUB PrintTotalWins
' Prints wins of full games
y = 1
FOR x = 1 TO 4
        COLOR Colors(x): LOCATE 1, y: PRINT "WINS:"; TotalWin(x);
        y = y + 23
NEXT x
END SUB

FUNCTION Rand% (Low, High)
Rand% = INT(RND * (High - Low + 1)) + Low
END FUNCTION

SUB ResetScore
CLS
PrintTotalWins
COLOR 15: LOCATE 13, 30: PRINT "RESET GAME WINS?"
DispMenu 4, 32, 14, pick
IF pick = 2 THEN
        ' Resets all total wins
        FOR x = 1 TO 4
                TotalWin(x) = 0
        NEXT x
        ' Writes all scores to zero
        Options.DataTotal1 = 0
        Options.DataTotal2 = 0
        Options.DataTotal3 = 0
        Options.DataTotal4 = 0
        PUT #1, 1, Options
END IF
END SUB

SUB SaveOptions
CLOSE #1
KILL PATH$ + "MANYWORM.DAT"
OPEN PATH$ + "MANYWORM.DAT" FOR RANDOM AS #1 LEN = LEN(Options)
' Saves all options
Options.DataWormSize = WormSize
Options.DataSpeed = Speed
Options.DataWall = Wall
Options.DataDensity = Density
Options.DataBoom = Boom
Options.DataWins = Wins
Options.DataRandStart = RandStart
Options.DataBoomStep = BoomStep
' Type of players
Options.DataComp1 = Worm(1).c
Options.DataComp2 = Worm(2).c
Options.DataComp3 = Worm(3).c
Options.DataComp4 = Worm(4).c
' Player 1 keys
Options.DataUp1 = Keys(1, 1)
Options.DataDown1 = Keys(1, 2)
Options.DataLeft1 = Keys(1, 3)
Options.DataRight1 = Keys(1, 4)
' Player 2 keys
Options.DataUp2 = Keys(2, 1)
Options.DataDown2 = Keys(2, 2)
Options.DataLeft2 = Keys(2, 3)
Options.DataRight2 = Keys(2, 4)
' Player 3 keys
Options.DataUp3 = Keys(3, 1)
Options.DataDown3 = Keys(3, 2)
Options.DataLeft3 = Keys(3, 3)
Options.DataRight3 = Keys(3, 4)
' Player 4 keys
Options.DataUp4 = Keys(4, 1)
Options.DataDown4 = Keys(4, 2)
Options.DataLeft4 = Keys(4, 3)
Options.DataRight4 = Keys(4, 4)
' Puts total wins
Options.DataTotal1 = TotalWin(1)
Options.DataTotal2 = TotalWin(2)
Options.DataTotal3 = TotalWin(3)
Options.DataTotal4 = TotalWin(4)
PUT #1, 1, Options
END SUB

SUB SetBoardSize
CLS
PrintTotalWins
COLOR 15: LOCATE 9, 32: PRINT "BOARD SIZE"
DispMenu 3, 26, 10, pick
WormSize = 10 - pick
END SUB

SUB SetBoardType
DIM k AS STRING
DIM nam AS STRING
DIM str1(0 TO 1) AS STRING
DIM str2(0 TO 1) AS STRING
CLS
PrintTotalWins
RESTORE walltype
FOR x = 0 TO 1
        READ str1(x)
NEXT x

RESTORE yesno
FOR x = 0 TO 1
        READ str2(x)
NEXT x

PrintTotalWins

' print menu
COLOR 15
LOCATE 10, 30: PRINT "NUMBER OF WINS:"; Wins
LOCATE 12, 30: PRINT "WALL TYPE: "; str1(Wall)
LOCATE 14, 30: PRINT "NUMBER OF WALLS:"; Density
LOCATE 16, 30: PRINT "SPEED:"; Speed
LOCATE 18, 30: PRINT "EXPLOSIONS:"; Boom
LOCATE 20, 30: PRINT "EXPLOSION DENSITY:"; BoomStep
LOCATE 22, 30: PRINT "RANDOM START SPOTS: "; str2(RandStart)
LOCATE 24, 30: PRINT "BACK TO OPTIONS MENU"

cr = MENUSTART
LOCATE cr, 28: PRINT CHR$(26)
DO
        k = UCASE$(INKEY$)
        IF k <> "" THEN
                LOCATE cr, 28: PRINT " "
        END IF
        SELECT CASE k
                CASE CHR$(0) + "H"
                        cr = cr - 2
                        IF cr < MENUSTART THEN cr = MENUEND
                CASE CHR$(0) + "P"
                        cr = cr + 2
                        IF cr > MENUEND THEN cr = MENUSTART
                CASE CHR$(13)
                        SELECT CASE cr
                                CASE 10
                                        LOCATE cr, 46: PRINT " "
                                        TypeStuff cr, 46, "", nam, 1
                                        IF nam = "" OR nam = "0" THEN
                                                Wins = 1
                                        ELSE
                                                Wins = VAL(nam)
                                        END IF
                                CASE 12
                                        IF Wall = 0 THEN
                                                Wall = 1
                                        ELSE
                                                Wall = 0
                                        END IF
                                CASE 14
                                        LOCATE cr, 47: PRINT "   "
                                        TypeStuff cr, 47, "", nam$, 3
                                        IF nam$ = "" THEN
                                                Density = 0
                                        ELSE
                                                Density = VAL(nam)
                                        END IF
                                CASE 16
                                        LOCATE cr, 37: PRINT "    "
                                        TypeStuff cr, 37, "", nam, 4
                                        IF nam = "" OR VAL(nam) = 0 THEN
                                                Speed = 1
                                        ELSE
                                                Speed = VAL(nam)
                                        END IF
                                CASE 18
                                        LOCATE cr, 42: PRINT "   "
                                        TypeStuff cr, 42, "", nam, 3
                                        IF nam = "" THEN
                                                Boom = 0
                                        ELSE
                                                Boom = VAL(nam)
                                        END IF
                                CASE 20
                                        LOCATE cr, 49: PRINT "   "
                                        TypeStuff cr, 49, "", nam, 3
                                        IF nam = "" THEN
                                                BoomStep = 0
                                        ELSE
                                                BoomStep = VAL(nam)
                                        END IF
                                CASE 22
                                        IF RandStart = 0 THEN
                                                RandStart = 1
                                        ELSE
                                                RandStart = 0
                                        END IF
                                CASE ELSE
                                        EXIT DO
                        END SELECT
        END SELECT
        IF k <> "" THEN
                LOCATE cr, 28: PRINT CHR$(26)
                LOCATE 10, 30: PRINT "NUMBER OF WINS:"; Wins
                LOCATE 12, 30: PRINT "WALL TYPE: "; str1(Wall)
                LOCATE 14, 30: PRINT "NUMBER OF WALLS:"; Density
                LOCATE 16, 30: PRINT "SPEED:"; Speed
                LOCATE 18, 30: PRINT "EXPLOSIONS:"; Boom
                LOCATE 20, 30: PRINT "EXPLOSION DENSITY:"; BoomStep
                LOCATE 22, 30: PRINT "RANDOM START SPOTS: "; str2(RandStart)
                LOCATE 24, 30: PRINT "BACK TO OPTIONS MENU"
        END IF
LOOP
END SUB

SUB SetColors
RESTORE playname
FOR x = 1 TO 4
        READ ColorName(x)
        READ Colors(x)
NEXT x
END SUB

SUB SetKeys
' Lets player set their keys
DIM k AS STRING
CLS
PrintTotalWins
y = 15
FOR x = 1 TO 4
        COLOR Colors(x): LOCATE 13, y: PRINT ColorName(x); ":"
        COLOR 15
        LOCATE 15, y: PRINT "UP:    "; Keys(x, 1)
        LOCATE 16, y: PRINT "DOWN:  "; Keys(x, 2)
        LOCATE 17, y: PRINT "LEFT:  "; Keys(x, 3)
        LOCATE 18, y: PRINT "RIGHT: "; Keys(x, 4)
        y = y + 15
NEXT x
LOCATE 22, 30: PRINT "BACK TO OPTIONS MENU"
ycr = 15
xcr = 13
xpos = 1
ypos = 1
LOCATE ycr, xcr: PRINT CHR$(26)
DO
        k = UCASE$(INKEY$)
        IF k <> "" THEN
                LOCATE ycr, xcr: PRINT " "
        END IF
        SELECT CASE k
                CASE CHR$(0) + "H"
                        IF ypos = 5 THEN
                                ypos = 4
                                ycr = 18
                                xcr = 13
                        ELSEIF ypos > 1 THEN
                                ypos = ypos - 1
                                ycr = ycr - 1
                        END IF
                CASE CHR$(0) + "P"
                        IF ypos = 4 THEN
                                ypos = 5
                                xpos = 1
                                ycr = 22
                                xcr = 28
                        ELSEIF ypos < 4 THEN
                                ypos = ypos% + 1
                                ycr = ycr% + 1
                        END IF
                CASE CHR$(0) + "K"
                        IF ypos < 5 THEN
                                IF xpos > 1 THEN
                                        xpos = xpos - 1
                                        xcr = xcr - 15
                                END IF
                        END IF
                CASE CHR$(0) + "M"
                        IF ypos < 5 THEN
                                IF xpos < 4 THEN
                                        xpos = xpos + 1
                                        xcr = xcr + 15
                                END IF
                        END IF
                CASE CHR$(13)
                        IF ypos < 5 THEN
                                LOCATE ycr, xcr + 9: PRINT "? "
                                LOCATE 10, 35: PRINT "CHOOSE A KEY"
                                DO
                                        k = UCASE$(INKEY$)
                                LOOP WHILE k = ""
                                LOCATE ycr, xcr + 9: PRINT "  "
                                LOCATE 10, 35: PRINT "            "
                                LOCATE ycr, xcr + 9: PRINT k
                                Keys(xpos, ypos) = k
                        ELSE
                                EXIT DO
                        END IF
        END SELECT
        IF k <> "" THEN
                LOCATE ycr, xcr: PRINT CHR$(26)
        END IF
LOOP
END SUB

SUB SetPlayers
' Loads current state name of player
DIM str1(0 TO 11) AS STRING
DIM k AS STRING
CLS
RESTORE onoff
FOR x = 0 TO 11
        READ str1(x)
NEXT x
PrintTotalWins
y = 10
FOR x = 1 TO 4
        COLOR Colors(x): LOCATE y, 30: PRINT ColorName(x); ": "; str1(Worm(x).c)
        y = y + 2
NEXT x
COLOR 15: LOCATE 18, 30: PRINT "BACK TO MAIN MENU"
cr = 10
LOCATE cr, 28: PRINT CHR$(26)
DO
        k = UCASE$(INKEY$)
        IF k <> "" THEN
                LOCATE cr, 28: PRINT " "
        END IF
        pick = cr / 2 - 4
        SELECT CASE k$
                CASE CHR$(0) + "H"
                        cr = cr - 2
                        IF cr < 10 THEN cr = 18
                CASE CHR$(0) + "P"
                        cr = cr + 2
                        IF cr > 18 THEN cr = 10
                CASE CHR$(0) + "K"
                        IF cr <> 18 THEN
                                Worm(pick).c = Worm(pick).c - 1
                                IF Worm(pick).c < 0 THEN Worm(pick).c = 11
                        END IF
                CASE CHR$(0) + "M"
                        IF cr <> 18 THEN
                                Worm(pick).c = Worm(pick).c + 1
                                IF Worm(pick).c > 11 THEN Worm(pick).c = 0
                        END IF
                CASE CHR$(13)
                        IF cr = 18 THEN EXIT DO
        END SELECT
        IF k <> "" THEN
                COLOR 15: LOCATE cr, 28: PRINT CHR$(26)
                y = 10
                FOR x = 1 TO 4
                        COLOR Colors(x): LOCATE y, 30: PRINT ColorName(x); ": "; str1(Worm(x%).c)
                        y = y + 2
                NEXT x
        END IF
LOOP
END SUB

SUB SetStartSpots
' Sets starting places for players
' Makes all players dead
Xmidpoint = (Xmax - Xmin) / 2 + Xmin    ' finds midpoints
Ymidpoint = (Ymax - Ymin) / 2 + Ymin    ' of screen
FOR x = 1 TO 4
        Worm(x).d = DEAD
NEXT x
IF RandStart = TRUE THEN
        FOR x = 1 TO 4
                IF Worm(x).c > 0 THEN
                        redo = TRUE
                        DO WHILE redo = TRUE
                                redo = FALSE
                                Worm(x).x = Rand(Xmin, Xmax)
                                Worm(x).y = Rand(Ymin, Ymax)
                                y = 1
                                DO UNTIL redo = TRUE OR y = x
                                        dist = SQR((Worm(x).x - Worm(y).x) ^ 2 + (Worm(x).y - Worm(y).y) ^ 2)
                                        IF dist < 10 THEN redo = TRUE
                                        y = y + 1
                                LOOP
                        LOOP
                        ' makes the worm start moving away from the nearest
                        ' wall
                        IF Rand(0, 1) = 0 THEN
                                IF Worm(x).x < Xmidpoint THEN
                                        Worm(x).d = RIGHT
                                ELSE
                                        Worm(x).d = LEFT
                                END IF
                        ELSE
                                IF Worm(x).y < Ymidpoint THEN
                                        Worm(x).d = DOWN
                                ELSE
                                        Worm(x).d = UP
                                END IF
                        END IF
                END IF
        NEXT x
ELSE
        ' Player 1 start spot
        IF Worm(1).c > 0 THEN Worm(1).d = RIGHT ' Checks to see if player is on
        Worm(1).x = 15
        Worm(1).y = 15
        ' Player 2 start spot
        IF Worm(2).c > 0 THEN Worm(2).d = LEFT ' Checks to see if player is on
        Worm(2).x = Xmax - 15
        Worm(2).y = Ymax - 15
        ' Player 3 start spot
        IF Worm(3).c > 0 THEN Worm(3).d = UP ' Checks to see if player is on
        Worm(3).x = 15
        Worm(3).y = Ymax - 15
        ' Player 4 start spot
        IF Worm(4).c > 0 THEN Worm(4).d = DOWN ' Checks to see if player is on
        Worm(4).x = Xmax - 15
        Worm(4).y = 15
END IF
END SUB

SUB SetVars
' Sets boundries for board
Xmin = 2
Xmax = INT(640 / WormSize) - 1
Ymin = 2
Ymax = INT(464 / WormSize) - 1
' Gets pictures
GetCirclePictures
' Resets number of rounds won
FOR x = 1 TO 4
        NumWin(x) = 0
NEXT x
END SUB

SUB TestCrash
IF Wall = WARP THEN
        WallWarp
END IF
' Point test doesn't work when two worms enter the same space at the same
' time so this is used to test for that
FOR x = 1 TO 4
        IF x <> CurrentWorm AND Worm(x).d < DEAD THEN
                IF Worm(CurrentWorm).x = Worm(x).x AND Worm(CurrentWorm).y = Worm(x).y THEN
                        PUT (Worm(CurrentWorm).x * WormSize, Worm(CurrentWorm).y * WormSize), StorePic(1, CurrentWorm), PSET
                        Crash
                END IF
        END IF
NEXT x
IF POINT(Worm(CurrentWorm).x * WormSize + INT(WormSize / 2), Worm(CurrentWorm).y * WormSize + INT(WormSize / 2)) > 0 THEN
        Crash
END IF
END SUB

FUNCTION TestKey% (k AS STRING)
' Changes worm's direction on command
IF k = Keys(CurrentWorm, 1) AND Worm(CurrentWorm).d <> DOWN THEN
        Worm(CurrentWorm).d = UP
        hit = TRUE
ELSEIF k = Keys(CurrentWorm, 2) AND Worm(CurrentWorm).d <> UP THEN
        Worm(CurrentWorm).d = DOWN
        hit = TRUE
ELSEIF k = Keys(CurrentWorm, 3) AND Worm(CurrentWorm).d <> RIGHT THEN
        Worm(CurrentWorm).d = LEFT
        hit = TRUE
ELSEIF k = Keys(CurrentWorm, 4) AND Worm(CurrentWorm).d <> LEFT THEN
        Worm(CurrentWorm).d = RIGHT
        hit = TRUE
END IF
TestKey% = hit
END FUNCTION

SUB TestSpeed
DIM StartTime AS LONG
DIM Time AS LONG
' calculates loops per second

StartTime = TIMER
DO
        Time = TIMER
LOOP WHILE StartTime = Time

StartTime = TIMER
DO
        Time = TIMER
        LoopSecond = LoopSecond + 1
LOOP WHILE StartTime = Time

END SUB

FUNCTION TestWinner%
FOR x = 1 TO 4
        IF Worm(x).d = DEAD THEN die = die + 1
NEXT x
IF die = 4 THEN
        BigLetter "DRAW", 10, 15, WORDSTYLE, 150
        won = 0
        Pause
ELSE
        FOR x = 1 TO 4
                IF Worm(x).d <> DEAD THEN
                        won = x
                END IF
        NEXT x
        NumWin(won) = NumWin(won) + 1
        colo = Colors(won)
        BigLetter ColorName(won), 10, colo, WORDSTYLE, 100
        BigLetter "WINS", 10, colo, WORDSTYLE, 225
        Pause
        IF NumWin(won) >= Wins THEN
                CLS
                IF TotalWin(won) < 999 THEN
                        TotalWin(won) = TotalWin(won) + 1
                        BigLetter ColorName(won), 10, colo, WORDSTYLE, 25
                        BigLetter "WINS", 10, colo, WORDSTYLE, 150
                        BigLetter "THE GAME", 10, colo, WORDSTYLE, 275
                        ' Writes total wins
                        Options.DataTotal1 = TotalWin(1)
                        Options.DataTotal2 = TotalWin(2)
                        Options.DataTotal3 = TotalWin(3)
                        Options.DataTotal4 = TotalWin(4)
                        PUT #1, 1, Options
                ELSE
                        BigLetter "YOU PLAY THIS", 6, 15, WORDSTYLE, 25
                        BigLetter "GAME WAY", 6, 15, WORDSTYLE, 150
                        BigLetter "TOO MUCH", 6, 15, WORDSTYLE, 275
                        Loser = 1
                END IF
                Pause
        END IF
END IF
TestWinner% = won
END FUNCTION

SUB TurnOnNumLock
DEF SEG = 0                         ' Set the current segment to the low memory area.
KeyFlags = PEEK(1047)               ' Read the location that holds the keyboard flag.
IF (KeyFlags AND 32) = 0 THEN       ' If the NUM LOCK key is off
        POKE 1047, KeyFlays OR 32   ' set the NUM LOCK key to on.
END IF
DEF SEG                             ' Restore the default segment.
END SUB

SUB TypeStuff (yy, xx, dis AS STRING, nam AS STRING, num)
DIM k AS STRING
cr = LEN(dis) + xx
LOCATE yy, xx: PRINT dis
LOCATE yy, cr: PRINT "_"' 95
nam = ""
DO
        k = INKEY$
        IF k <> "" THEN
                IF ASC(k) > 47 AND ASC(k) < 58 AND LEN(nam) < num THEN
                        nam = nam + k
                        LOCATE yy, cr: PRINT k
                        cr = cr + 1
                        LOCATE yy, cr: PRINT "_"
                ELSEIF (k = CHR$(8) OR k = CHR$(0) + "K") AND LEN(nam) > 0 THEN
                        nam = LEFT$(nam, LEN(nam) - 1)
                        LOCATE yy, cr: PRINT " "
                        cr = cr - 1
                        LOCATE yy, cr: PRINT "_"
                END IF
        END IF
LOOP UNTIL k = CHR$(13)
LOCATE yy, cr: PRINT " "
END SUB

SUB WallWarp
' Wraps worm back on the screen
' X axis
IF Worm(CurrentWorm).x < 1 THEN
        Worm(CurrentWorm).x = Xmax - 1
ELSEIF Worm(CurrentWorm).x > Xmax - 1 THEN
        Worm(CurrentWorm).x = 1
END IF
' Y axis
IF Worm(CurrentWorm).y < 1 THEN
        Worm(CurrentWorm).y = Ymax - 1
ELSEIF Worm(CurrentWorm).y > Ymax - 1 THEN
        Worm(CurrentWorm).y = 1
END IF
END SUB

